/*
 * bdclLayerManager.h
 *
 *  Created on: Jan 2, 2017
 *      Author: pgovindaraju
 */

#ifndef DEMO_PROTOTYPE_BDCL_DEMO_SRC_UTILS_BDCLLAYERMANAGER_H_
#define DEMO_PROTOTYPE_BDCL_DEMO_SRC_UTILS_BDCLLAYERMANAGER_H_

#include <adit_logging.h>
#include <string>
#include <ilm/ilm_client.h>
#include <ilm/ilm_control.h>

namespace adit { namespace bdcl
{
using namespace std;

#define LAYER_ID            3000
#define SURFACE_ID          40
#define DISPLAY_ID          1

#define TOUCH_LAYER_ID      3001
#define TOUCH_SURFACE_ID    41

// Screen/touch resolution
#ifdef IMX_DEMO
    #define RES_WIDTH       800
    #define RES_HEIGHT      480
    #define DEVICE_MAX      10
#else
    #define RES_WIDTH       1280
    #define RES_HEIGHT      720
    #define DEVICE_MAX      1
#endif

#define RES_WIDTH_GAL       800
#define RES_HEIGHT_GAL      480

typedef struct surfaceDimensions_t
{
    t_ilm_uint      srcWidth;
    t_ilm_uint      srcHeight;
    t_ilm_uint      destWidth;
    t_ilm_uint      destHeight;

} surfaceDimensions;


class bdclLayerManager
{
public:
    bdclLayerManager();
    //    bdclLayerManager(IDynamicConfiguration& inConfig);
    ~bdclLayerManager();

    // Server
//    bool addMobileDevice(string inDeviceSerial);
//    void deleteMobileDevice(string inDeviceSerial);
    void finalize();
//
//    // onKeyEventDeviceSelection
//    bool bringDeviceToFront(const int inDeviceIndex);

    // Server
    t_ilm_layer getLayerId() const;
    t_ilm_surface getSurfaceId(string inDeviceSerial) const;
    bool init();

    static void ilmNotifyCB(ilmObjectType object, t_ilm_uint id, t_ilm_bool created, void *user_data);

protected:
    void configure_ilm_surface(t_ilm_uint id, t_ilm_uint width, t_ilm_uint height);

private:
//    map<string, mobileDeviceSettings> mMobileDevices;
    pthread_mutex_t orderMutex;

    bool mIlmInit;
    t_ilm_display mDisplayId;
    t_ilm_layer mLayerId;
    t_ilm_surface mSurfaceId;
    string mActiveDevice;

    int32_t mMaxDevices;

//    IDynamicConfiguration* mConfig;
    bool createLayer(const t_ilm_uint inSrcWidth, const t_ilm_uint inSrcHeight);
    int getFreeDeviceIndex();

    void removeSurface(const t_ilm_surface inSurfaceId);
    void removeLayer();

    bool refreshZOrder(const string inDeviceSerial);

};
} } /* namespace adit { namespace bdcl */




#endif /* DEMO_PROTOTYPE_BDCL_DEMO_SRC_UTILS_BDCLLAYERMANAGER_H_ */
